unit IWDsnPaint;

interface

{$I IWCompilerDefines.inc}

{$IFNDEF OBFUSCATE}
{$R IWDsnPaintSupport.res}
{$ENDIF}

uses
  Classes,
  {$IFDEF VSNET}
  System.Drawing,
  Windows, Types,
  {$ELSE}
  {$IFDEF Linux}Types, {$ELSE}Windows, {$IFDEF VCL6ORABOVE}Types, {$ENDIF}{$ENDIF}
  {$IFDEF Linux}QButtons, {$ELSE}Buttons,{$ENDIF}
  {$ENDIF}
  {$IFDEF Linux}QGraphics,{$ELSE}Graphics,{$ENDIF}
  IWBaseControl, IWFont, IWColor;

type
  TArrowDirection = (adUp, adDown, adLeft, adRight);

  TSides = (ssLeft, ssTop, ssRight, ssBottom);
  TSidesSet = set of TSides;

  TIWPaintHandlerDsn = class(TIWPaintHandler)
  protected
    procedure DrawOutline(const ABGColor: TColor = clSilver); overload;
    procedure DrawOutline(const ALeft, ATop, ARight, ABottom: Integer;
      const ABGColor: TColor = clSilver); overload;
    procedure DrawResource(const AName: string; const ALeft: Integer; const ATop: Integer);
    procedure SetTransparent;
    procedure Draw3DBox(ABoxRect: TRect; ABorderWidth: Integer = 1;
      ABorderColor: TColor = clSilver; ALightSides: TSidesSet = [ssBottom, ssRight]); overload;
    procedure Draw3DBox; overload;
    // procedure Draw3DBox(X1, Y1, X2, Y2: Integer); overload;
    procedure DrawArrow(ARect: TRect; ADirection: TArrowDirection);
    function DrawButton(const AClient: TRect; const ABevelWidth: Integer = 1;
      const AIsDown: Boolean = False; const AIsFocused: Boolean = False): TRect;
    procedure DrawScrollBar(ARect: TRect);
    procedure DrawTextLines(ARect: TRect; AText: TStrings; AWordWrap: boolean = False);
    procedure SetCanvasFont(AFont: TIWFont);
  public
    procedure Paint; override;
  end;

  TIWPaintHandlerComponent = class(TIWPaintHandlerDsn)
  public
    procedure Paint; override;
  end;

{$IFDEF VSNET}
function InflateRect(Var ARect: TRect; dx, dy: Integer): Boolean;
{$ENDIF}

implementation

uses
  SysUtils,
  SWSystem;

{$IFDEF VSNET}

function InflateRect(Var ARect: TRect; dx, dy: Integer): Boolean;
begin
  ARect.Left := ARect.Left - dx;
  ARect.Right := ARect.Right + dx;

  ARect.Top := ARect.Top - dy;
  ARect.Bottom := ARect.Bottom + dy;

  result := (ARect.Left <= ARect.Right) and (ARect.Top <= ARect.Bottom); 
end;

procedure Frame3D(Canvas: TCanvas; var Rect: TRect; TopColor, BottomColor: TColor;
  Width: Integer);

  procedure DoRect;
  var
    TopRight, BottomLeft: TPoint;
  begin
    with Canvas do
    begin
      TopRight.X := Rect.Right;
      TopRight.Y := Rect.Top;
      BottomLeft.X := Rect.Left;
      BottomLeft.Y := Rect.Bottom;
      Pen.Color := TopColor;
      PolyLine([BottomLeft, Rect.TopLeft, TopRight]);
      Pen.Color := BottomColor;
      Dec(BottomLeft.X);
      PolyLine([TopRight, Rect.BottomRight, BottomLeft]);
    end;
  end;

begin
  Canvas.Pen.Width := 1;
  Dec(Rect.Bottom); Dec(Rect.Right);
  while Width > 0 do
  begin
    Dec(Width);
    DoRect;
    InflateRect(Rect, -1, -1);
  end;
  Inc(Rect.Bottom); Inc(Rect.Right);
end;

{ DrawButtonFace - returns the remaining usable area inside the Client rect.}
function DrawButtonFace(Canvas: TCanvas; const Client: TRect;
  BevelWidth: Integer; {Style: TButtonStyle; }IsRounded, IsDown,
  IsFocused: Boolean): TRect;
var
  NewStyle: Boolean;
  R: TRect;
  DC: THandle;
begin
  // NewStyle := ((Style = bsAutoDetect) and NewStyleControls) or (Style = bsNew);

  NewStyle := true;

  R := Client;
  with Canvas do
  begin
    if NewStyle then
    begin
      Brush.Color := clBtnFace;
      Brush.Style := bsSolid;
      DC := Canvas.Handle;    { Reduce calls to GetHandle }

      if IsDown then
      begin    { DrawEdge is faster than Polyline }
        DrawEdge(DC, R, BDR_SUNKENINNER, BF_TOPLEFT);              { black     }
        DrawEdge(DC, R, BDR_SUNKENOUTER, BF_BOTTOMRIGHT);          { btnhilite }
        Dec(R.Bottom);
        Dec(R.Right);
        Inc(R.Top);
        Inc(R.Left);
        DrawEdge(DC, R, BDR_SUNKENOUTER, BF_TOPLEFT or BF_MIDDLE); { btnshadow }
      end
      else
      begin
        DrawEdge(DC, R, BDR_RAISEDOUTER, BF_BOTTOMRIGHT);          { black }
        Dec(R.Bottom);
        Dec(R.Right);
        DrawEdge(DC, R, BDR_RAISEDINNER, BF_TOPLEFT);              { btnhilite }
        Inc(R.Top);
        Inc(R.Left);
        DrawEdge(DC, R, BDR_RAISEDINNER, BF_BOTTOMRIGHT or BF_MIDDLE); { btnshadow }
      end;
    end
    else
    begin
      Pen.Color := clWindowFrame;
      Brush.Color := clBtnFace;
      Brush.Style := bsSolid;
      Rectangle(R.Left, R.Top, R.Right, R.Bottom);

      { round the corners - only applies to Win 3.1 style buttons }
      if IsRounded then
      begin
        Pixels[R.Left, R.Top] := clBtnFace;
        Pixels[R.Left, R.Bottom - 1] := clBtnFace;
        Pixels[R.Right - 1, R.Top] := clBtnFace;
        Pixels[R.Right - 1, R.Bottom - 1] := clBtnFace;
      end;
    
      if IsFocused then
      begin
        InflateRect(R, -1, -1);
        Brush.Style := bsClear;
        Rectangle(R.Left, R.Top, R.Right, R.Bottom);
      end;
    
      InflateRect(R, -1, -1);
      if not IsDown then
        Frame3D(Canvas, R, clBtnHighlight, clBtnShadow, BevelWidth)
      else
      begin
        Pen.Color := clBtnShadow;
        PolyLine([Point(R.Left, R.Bottom - 1), R.TopLeft, Point(R.Right, R.Top)]);
      end;
    end;
  end;

  Result := {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Rect(Client.Left + 1, Client.Top + 1, Client.Right - 2, Client.Bottom - 2);
  if IsDown then OffsetRect(Result, 1, 1);
end;
{$ENDIF}

{ TIWPaintHandlerDsn }

procedure TIWPaintHandlerDsn.SetCanvasFont(AFont: TIWFont);
begin
  with ControlCanvas do begin
    Font.Assign(AFont);
    if (toTColor(AFont.Color) = clNone) or (toTColor(AFont.Color) = clWebTransparent) then begin
      Font.Color := clBlack;
    end;
  end;
end;

procedure TIWPaintHandlerDsn.DrawOutline(const ABGColor: TColor = clSilver);
var
  LPoints: array[0..4] of TPoint;
begin
  with ControlCanvas do begin
    Brush.Style := bsSolid;
    Brush.Color := ABGColor;
    FillRect({$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Rect(0, 0, Control.Width, Control.Height));
    Pen.Color := clBlack;
    // FrameRect does not exist in Kylix 1. Maybe Kylix 2?
    LPoints[0] := Point(0, 0);
    LPoints[1] := Point(Control.Width - 1, 0);
    LPoints[2] := Point(Control.Width - 1, Control.Height - 1);
    LPoints[3] := Point(0, Control.Height - 1);
    LPoints[4] := Point(0, 0);
    Polyline(LPoints);
  end;
end;

procedure TIWPaintHandlerDsn.DrawResource(const AName: string; const ALeft, ATop: Integer);
var
  LBitmap: TBitmap;
  LInstance: LongWord;
  LName: String;
begin
  LInstance := FindInstanceContainingResource(UpperCase(AName), RT_BITMAP);
  LName := UpperCase(AName);
  if LInstance = 0 then begin
    // Paint Blank Image for components without coresponding palette image
    LInstance := FindInstanceContainingResource(UpperCase('BLANK'), RT_BITMAP);
    LName := 'BLANK';
  end;
  if LInstance <> 0 then begin
    LBitMap := TBitmap.Create; try
      LBitMap.LoadFromResourceName(LInstance, LName);
      ControlCanvas.Draw(ALeft, ATop, LBitMap);
    finally FreeAndNil(LBitMap); end;
  end;
end;

procedure TIWPaintHandlerDsn.Paint;
begin
  DrawOutline;
end;

procedure TIWPaintHandlerDsn.SetTransparent;
begin
  {$IFNDEF VSNET}
  {$IFNDEF Linux}
  SetBKMode(ControlCanvas.Handle, TRANSPARENT);
  {$ENDIF}
  {$ENDIF}
end;

procedure TIWPaintHandlerDsn.Draw3DBox;
begin
  Draw3DBox({$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Rect(0, 0, Control.Width - 1, Control.Height - 1));
end;

{$IFDEF Linux}
function GetRValue(AColor: LongWord): Byte;
begin
  result := Byte(AColor);
end;

function GetGValue(AColor: LongWord): Byte;
begin
  result := Byte(AColor shr 8);
end;

function GetBValue(AColor: LongWord): Byte;
begin
  result := Byte(AColor shr 16);
end;

function RGB(R, G, B: Byte): LongWord;
begin
  result := R or (Word(G) shl 8) or (LongWOrd(B) shl 16); 
end;
{$ENDIF}

procedure TIWPaintHandlerDsn.Draw3DBox(ABoxRect: TRect; ABorderWidth: Integer = 1;
  ABorderColor: TColor = clSilver; ALightSides: TSidesSet = [ssBottom, ssRight]);
Var
  I: Integer;
  R, G, B: Integer;
  LLightColor: TColor;
  LDarkColor: TColor;
begin
  with ControlCanvas do begin
    Pen.Style := psSolid;
    Pen.Width := 1;

    LLightColor := ABorderColor;

    R := GetRValue(ABorderColor) div 2;
    G := GetGValue(ABorderColor) div 2;
    B := GetBValue(ABorderColor) div 2;
    LDarkColor := RGB(R, G, B);

    if ssLeft in ALightSides then
      Pen.Color := LLightColor
    else
      Pen.Color := LDarkColor;

    for i := 0 to ABorderWidth - 1 do begin
      MoveTo(ABoxRect.Left + i, ABoxRect.Top + i);
      LineTo(ABoxRect.Left + i, ABoxRect.Bottom - i);
    end;

    if ssTop in ALightSides then
      Pen.Color := LLightColor
    else
      Pen.Color := LDarkColor;

    for i := 0 to ABorderWidth - 1 do begin
      MoveTo(ABoxRect.Left + i, ABoxRect.Top + i);
      LineTo(ABoxRect.Right - i, ABoxRect.Top + i);
    end;

    if ssRight in ALightSides then
      Pen.Color := LLightColor
    else
      Pen.Color := LDarkColor;

    for i := 0 to ABorderWidth - 1 do begin
      MoveTo(ABoxRect.Right - i, ABoxRect.Top + i);
      LineTo(ABoxRect.Right - i, ABoxRect.Bottom - i);
    end;

    if ssBottom in ALightSides then
      Pen.Color := LLightColor
    else
      Pen.Color := LDarkColor;

    for i := 0 to ABorderWidth - 1 do begin
      MoveTo(ABoxRect.Left + i, ABoxRect.Bottom - i);
      LineTo(ABoxRect.Right - i + 1, ABoxRect.Bottom - i);
    end;
  end;
end;

(*procedure TIWPaintHandlerDsn.Draw3DBox(X1, Y1, X2, Y2: Integer);
Var
  ARect: TRect;
  i: Integer;
  LWidth: Integer;
begin
  ARect := {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Rect(X1, Y1, X2, Y2);
  with ControlCanvas do begin
    LWidth := Pen.Width;
    Pen.Width := 1;
    for i := 0 to LWidth - 1  do begin
      {$IFDEF Linux}
      DrawEdge(ControlCanvas, R, esNone, esLowered, [ebBottom, ebRight]);
      {$ELSE}
      DrawEdge(Handle, ARect, BDR_SUNKENOUTER, BF_TOPLEFT);
      DrawEdge(Handle, ARect, BDR_SUNKENINNER, BF_BOTTOMRIGHT);
      InflateRect(ARect, -1, -1);
      {$ENDIF}
    end;
    {Pen.Color := clGray;
    MoveTo(X1, Y1);
    LineTo(X2 - 1, Y1);
    MoveTo(X1, Y1);
    LineTo(X1, Y2 - 1);
    MoveTo(X1 + 1, Y1 + 1);
    Pen.Color := $00404040;
    LineTo(X2 - 2, Y1 + 1);
    MoveTo(X1 + 1, Y1 + 1);
    LineTo(X1 + 1, Y2 - 2);
    Pen.Color := clGray;
    MoveTo(X2 - 1, Y1);
    LineTo(X2 - 1, Y2);
    MoveTo(X1, Y2 - 1);
    LineTo(X2 - 1, Y2 - 1);}
  end;
end;*)

procedure TIWPaintHandlerDsn.DrawArrow(ARect: TRect; ADirection: TArrowDirection);
var
  Mid: Integer;
begin
  with ControlCanvas do begin
    Brush.Color := clBlack;
    Pen.Color := clBlack;
    case Ord(ADirection) of
      0: // Up
        begin
          Mid := (ARect.Right + ARect.Left) div 2;
          Polygon([Point(Mid, ARect.Top + 5), Point(Arect.Right - 3, ARect.Bottom - 5),
            Point(Arect.Left + 3, ARect.Bottom - 5), Point(Mid, ARect.Top + 5)]);
        end;
      1: // Down
        begin
          Mid := (ARect.Right + ARect.Left) div 2;
          Polygon([Point(Mid, ARect.Bottom - 5), Point(ARect.Right - 3, ARect.Top + 5),
            Point(ARect.Left + 3, ARect.Top + 5), Point(Mid, ARect.Bottom - 5)]);
        end;
      2: // Left
        begin
          Mid := (ARect.Top + ARect.Bottom) div 2;
          Polygon([Point(ARect.Left + 3, Mid), Point(ARect.Right - 3, ARect.Top + 2),
            Point(ARect.Right - 3, ARect.Bottom - 2), Point(ARect.Left + 3, Mid)]);
        end;
      3: // Right
        begin
          Mid := (ARect.Top + ARect.Bottom) div 2;
          Polygon([Point(ARect.Left + 3, ARect.Top + 2), Point(ARect.Right - 3, Mid),
            Point(ARect.Left + 3, ARect.Bottom - 2), Point(ARect.Left + 3, ARect.Top + 2)]);
        end;
    end;
  end;
end;

procedure TIWPaintHandlerDsn.DrawScrollBar(ARect: TRect);
var
  LRect: TRect;
begin
  LRect := DrawButton({$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Rect(ARect.Left, ARect.Top + 1, ARect.Right, 18));
  DrawArrow(LRect, adUp);
  LRect := DrawButton(
    {$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Rect(ARect.Left, ARect.Bottom - 16, ARect.Right, ARect.Bottom - ARect.Top + 1));
  DrawArrow(LRect, adDown);
{  with FCanvas do begin
    Pen.Color := clSilver;
    MoveTo(ARect.Left - 1,ARect.Top + 1);
    LineTo(ARect.Left - 1, ARect.Bottom + 1);
  end;}
end;

procedure TIWPaintHandlerDsn.DrawTextLines(ARect: TRect; AText: TStrings; AWordWrap: boolean = False);
var
  YPos: Integer;
  Ln: Integer;
  Bt: Integer;
  LText: string;
  LTempStr : string;
  f : integer;
begin
  Ln := 0;
  YPos := ARect.Top;
  ControlCanvas.Brush.Style := bsClear;
  LTempStr := '';
  while (YPos < ARect.Bottom) and (Ln < AText.Count) do begin
    if AWordWrap then
    begin
      if (LTempStr = '') then
      begin
        LText := AText.Strings[Ln];
      end
      else
      begin
        LText := LTempStr;
      end;
    end
    else
    begin
      LText := AText.Strings[Ln];
    end;
    if Length(LText) < 1 then
    begin
      LText := ' ';
    end;
    Bt := YPos + ControlCanvas.TextHeight(LText);

    if AWordWrap then
    begin
      f := Length(LText);
      while (ControlCanvas.TextWidth(Copy(LText, 1, f)) > ARect.Right - ARect.Left) and
            (f > 1) do
      begin
        Dec(f);
      end;

      if (f <> Length(LText)) and
         ((Pos(#32, LText) <= f) or (Pos(#9, LText) <= f)) then
      begin
        while (not (LText[f] in [#32, #9, #10, #13])) and (f > 1) do
        begin
          Dec(f);
        end;
      end;

      LTempStr := Copy(LText, f + 1, Length(LText));
      LText := Copy(LText, 1, f);
    end;
    ControlCanvas.TextRect({$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Rect(ARect.Left, YPos, ARect.Right - ARect.Left, Bt), ARect.Left, YPos
      , LText);
    if LTempStr = '' then
    begin
      Inc(Ln);
    end;
    YPos := Bt;
  end;
end;

function TIWPaintHandlerDsn.DrawButton(const AClient: TRect;
  const ABevelWidth: Integer; const AIsDown, AIsFocused: Boolean): TRect;
begin
  Result := DrawButtonFace(ControlCanvas, AClient, ABevelWidth
{$IFNDEF Linux}, {$IFNDEF VSNET}bsAutoDetect,{$ENDIF} False{$ENDIF}, AIsDown, AIsFocused);
end;

procedure TIWPaintHandlerDsn.DrawOutline(const ALeft, ATop,
  ARight, ABottom: Integer; const ABGColor: TColor);
var
  LPoints: array[0..4] of TPoint;
begin
  with ControlCanvas do begin
    Brush.Style := bsSolid;
    Brush.Color := ABGColor;
    FillRect({$IFDEF VSNET}Borland.VCL.Types.{$ENDIF}Rect(ALeft, ATop, ARight, ABottom));
    Pen.Color := clBlack;
    // FrameRect does not exist in Kylix 1. Maybe Kylix 2?
    LPoints[0] := Point(ALeft, ATop);
    LPoints[1] := Point(ARight - 1, ATop);
    LPoints[2] := Point(ARight - 1, ABottom - 1);
    LPoints[3] := Point(ALeft, ABottom - 1);
    LPoints[4] := Point(ALeft, ATop);
    Polyline(LPoints);
  end;
end;

{ TIWPaintHandlerComponent }

procedure TIWPaintHandlerComponent.Paint;
begin
  DrawOutline;
  DrawResource(Control.ClassName, (Control.Width - 24) div 2, (Control.Height - 24) div 2);
end;

initialization
  GDefaultPaintHandler := TIWPaintHandlerComponent;
end.


